(*
  TGradientPanel 1.0 written by Christian Arndt / phlux (admin at chaos-raid dot com)

  V 1.0 - 12.Okt 2002 : First release of TGradientPanel
*)

unit GradientPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TDirection = (drLeftToRight, drTopToBottom);
  TCaptionAlign = (alLeft, alCenter, alRight);
  TCaptionVAlign = (alTop, alMiddle, alBottom);
  TGradientPanel = class(TPanel)
  private
    { Private-Deklarationen }
    fDirection: TDirection;
    fColorStart: TColor;
    fColorEnd: TColor;
    fCaptionAlign: TCaptionAlign;
    fCaptionVALign: TCaptionVAlign;
    fCaptionPadding: Integer;
    procedure SetDirection(Direction: TDirection);
    procedure SetColorStart(Color: TColor);
    procedure SetColorEnd(Color: TColor);
    procedure SetCaptionAlign(CaptionAlign: TCaptionAlign);
    procedure SetCaptionVAlign(CaptionVAlign: TCaptionVAlign);
    procedure SetCaptionPadding(CaptionPadding: Integer);
  protected
    { Protected-Deklarationen }
    procedure Paint; override;
  public
    { Public-Deklarationen }
    constructor Create(aOwner: TComponent); override;
    procedure Gradient;
  published
    { Published-Deklarationen }
    property Direction: TDirection read fDirection write SetDirection;
    property ColorStart: TColor read fColorStart write SetColorStart default clGray;
    property ColorEnd: TColor read fColorEnd write SetColorEnd default clWhite;
    property CaptionAlign: TCaptionAlign read fCaptionAlign write SetCaptionAlign;
    property CaptionVAlign: TCaptionVAlign read fCaptionVAlign write SetCaptionVAlign;
    property CaptionPadding: Integer read fCaptionPadding write SetCaptionPadding;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CR-Soft', [TGradientPanel]);
end;

constructor TGradientPanel.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  fColorStart := clGray;
  fColorEnd := clWhite;
  fDirection := drLeftToRight;
  fCaptionPadding := 5;
end;

procedure TGradientPanel.SetDirection(Direction: TDirection);
begin
  If fDirection <> Direction then
    fDirection := Direction;
  invalidate;
end;

procedure TGradientPanel.SetColorStart(Color: TColor);
begin
  If fColorStart <> Color then
    fColorStart := Color;
  invalidate;
end;

procedure TGradientPanel.SetColorEnd(Color: TColor);
begin
  If fColorEnd <> Color then
    fColorEnd := Color;
  invalidate;
end;

procedure TGradientPanel.Paint;
begin
  inherited Paint;
  Gradient;
end;

procedure TGradientPanel.Gradient;
var Rect: TRect;
    Length, i: Integer;
    R, G, B: Byte;
    TextFont: TFont;
    TextPosX, TextPosY: Integer;
    TextWidth, TextHeight: Integer;

begin
  Rect.Top := 0;
  Rect.Left := 0;
  Rect.Bottom := Self.Height;
  Rect.Right := Self.Width;

  TextFont := Self.Font;

  TextPosX := 0;
  TextPosY := 0;
  Length := 0;

  TextWidth := Canvas.TextWidth(Self.Caption);
  TextHeight := Canvas.TextHeight(Self.Caption);

  case fCaptionAlign of
    alLeft : Begin
               TextPosX := Rect.Left + fCaptionPadding;
             End;
    alCenter : Begin
                 TextPosX := (Rect.Right div 2) - (TextWidth div 2);
               End;
    alRight : Begin
                TextPosX := Rect.Right - TextWidth - fCaptionPadding;
              End;
  end;

  case fCaptionVAlign of
    alTop : Begin
              TextPosY := Rect.Top + fCaptionPadding;
            End;
    alMiddle : Begin
                 TextPosY := (Rect.Bottom div 2) - (TextHeight div 2);
               End;
    alBottom : Begin
                 TextPosY := Rect.Bottom - TextHeight - fCaptionPadding;
               End;
  end;

  case fDirection of
    drLeftToRight : Length := Rect.Right;
    drTopToBottom : Length := Rect.Bottom;
  end;

  for i := 0 to Length do
  begin
    R := Round(GetRValue(fColorStart) + ((GetRValue(fColorEnd) - GetRValue(fColorStart)) * i / (Length)));
    G := Round(GetGValue(fColorStart) + ((GetGValue(fColorEnd) - GetGValue(fColorStart)) * i / (Length)));
    B := Round(GetBValue(fColorStart) + ((GetBValue(fColorEnd) - GetBValue(fColorStart)) * i / (Length)));

    Canvas.Pen.Color := RGB(R, G, B);
    Canvas.Pen.Width := 1;
    Canvas.Pen.Style := psInsideFrame;

    case fDirection of
      drLeftToRight : Begin
                        Canvas.MoveTo(i, Rect.Top);
                        Canvas.LineTo(i, Rect.Bottom);
                      End;
      drTopToBottom : Begin
                        Canvas.MoveTo(Rect.Left, i);
                        Canvas.LineTo(Rect.Right, i);
                      End;
    end;

    Canvas.Font := TextFont;
    Canvas.Brush.Style := bsClear;
    Canvas.TextOut(TextPosX, TextPosY, Self.Caption);
  end;

end;

procedure TGradientPanel.SetCaptionAlign(CaptionALign: TCaptionAlign);
begin
  If fCaptionAlign <> CaptionAlign then
    fCaptionAlign := CaptionAlign;
  invalidate;
end;

procedure TGradientPanel.SetCaptionVAlign(CaptionVAlign: TCaptionVAlign);
begin
  If fCaptionVAlign <> CaptionVAlign then
    fCaptionVAlign := CaptionVAlign;
  invalidate;
end;

procedure TGradientPanel.SetCaptionPadding(CaptionPadding: Integer);
begin
  if fCaptionPadding <> CaptionPadding then
    fCaptionPadding := CaptionPadding;
  invalidate;
end;

end.
